<?php
/**
 * By Uriel
 */
class ControladorSolicitudes
{
    /*=============================================
    MOSTRAR LISTADO DE SOLICITUDES
    =============================================*/
    public static function ctrGetSolicitudes($fechainicial,$fechafinal,$status,$respon){
        $tabla = "tbl_solicitudes";
        $respuesta = ModeloSolicitudes::mdlMostrarSolicitudes($tabla,$fechainicial,$fechafinal,$status,$respon);
        return $respuesta;
    }
    static public function ctrInsertarSolicitudAjax($datos){
        $tabla = "tbl_solicitudes";
        $respuestaDetalle = ModeloSolicitudes::mdlIngresarSolicitud($tabla, $datos);
        return $respuestaDetalle;
    }
    static public function ctrGetUltimoFolio(){
         $tabla = "tbl_solicitudes";
         $UltimoFolio = ModeloSolicitudes::mdlGetUltimoFolio($tabla);
         return $UltimoFolio;
    }
    /*=============================================
      GET DE DEPARTAMENTOS PARA MOSTRAR EN SELECT DE detallesSolicitud
    =============================================*/
    public static function ctrGetServicios($item,$valor){
        $tabla = "cat_tipos_servicios";
        $servicios = ModeloSolicitudes::mdlMostrarServicios($tabla,$item,$valor);
        //echo $valor; exit;
        return $servicios;
    }
    /*=============================================
      INSERTAR DETALLES DE LA SOLICITUD (UPDATE)
    =============================================*/
    static public function ctrInsertarDetallesSoliAjax($datos){
        $tabla = "tbl_solicitudes";
        $item = "id_solicitud";
        $selectMoneda = ModeloSolicitudes::mdlMostrarSolicitudes_($tabla, $item, $datos['id_solicitud']);


        $monedaid;
        if ($selectMoneda['moneda_descripcion'] == "MXN") {
          $monedaid = 1;
        }
        else {
            $monedaid = 2;
        }
        $retorno = array_merge($datos, array('soli_ultimo_tipoCambio' => $monedaid));
        $respuestaDetalle = ModeloSolicitudes::mdlDetallesDeLaSolicitud($tabla, $retorno);



        return $respuestaDetalle;
    }
    /*=============================================
      INSERTAR MATERIALES X SOLICITUD
    =============================================*/
    static public function ctrInsertarMaterialesAjax($datos){
        $tabla = "tbl_materiales";
        $respuestaDetalle = ModeloSolicitudes::mdlInsertarMateriales($tabla, $datos);
        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud en MXN
          $suma = ModeloSolicitudes::mdlSumaTotalMaterial($tabla, $datos['fk_id_solicitud']);
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud en USD
          $sumaDlls = ModeloSolicitudes::mdlSumaTotalMaterialDlls($tabla, $datos['fk_id_solicitud']);
          #actualizar el campo de total
          $tbl = "tbl_solicitudes";
          $data = array('id_solicitud' => $datos['fk_id_solicitud'],
                        'soli_sumatoria_materiales' => $suma['total'],
                        'soli_sumatoria_materiales_dlls' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);


          $sumTotalMaterial = ModeloSolicitudes::mdlActualizarTotalesMaterial($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesSolicitud == "ok") {
              return "insert";
          }
        }
    }
    /*=============================================
      GET A MATERIALES
    =============================================*/
    public static function ctrGetMateriales($item,$valor){
        $tabla = "tbl_materiales";
        $respuesta = ModeloSolicitudes::mdlMostrarMateriales($tabla,$item,$valor);

        return $respuesta;
    }
    /*=============================================
      GET A TOTALES DE LA SOLICITUD
    =============================================*/
    public static function ctrGetTotalSolicitud($item,$valor){
        $tabla = "tbl_solicitudes";
        $respuesta = ModeloSolicitudes::mdlMostrarSolicitudes_($tabla,$item,$valor);
        //echo $valor; exit;
        return $respuesta;
    }
    /*=============================================
      EDITAR PARTIDA DE  MATERIAL WHERE id_material
    =============================================*/
    static public function ctrEditarMaterialAjax($datos){
        $tabla = "tbl_materiales";
        $respuestaDetalle = ModeloSolicitudes::mdlEditMaterial($tabla, $datos);

        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud
          $suma = ModeloSolicitudes::mdlSumaTotalMaterial($tabla, $datos['fk_id_solicitud']);
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud en USD
          $sumaDlls = ModeloSolicitudes::mdlSumaTotalMaterialDlls($tabla, $datos['fk_id_solicitud']);

          #actualizar el campo de total
          $tbl = "tbl_solicitudes";
          $data = array('id_solicitud' => $datos['fk_id_solicitud'],
                        'soli_sumatoria_materiales' => $suma['total'],
                        'soli_sumatoria_materiales_dlls' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);
          $sumTotalMaterial = ModeloSolicitudes::mdlActualizarTotalesMaterial($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotalesDlls($tbl,$data);

          if ($sumaTotalesSolicitud == "ok") {
              return "EditOK";
          }
        }

    }
    /*=============================================
      GET A MATERIALES where id
    =============================================*/
    public static function ctrGetMaterialesWhereId($item,$valor){
        $tabla = "tbl_materiales";
        $respuesta = ModeloSolicitudes::mdlMostrarMaterialesWhereID($tabla,$item,$valor);

        return $respuesta;
    }
    /*=============================================
      ELIMINAR MATERIAL WHERE ID
    =============================================*/
    public static function ctrDeleteMaterial($item,$id_solicitud, $id_material, $cantidad){
        $tabla = "tbl_materiales";
        $respuesta = ModeloSolicitudes::mdlDeleteMaterial($tabla,$id_material);
        if ($respuesta == "ok") {

          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud
          $suma = ModeloSolicitudes::mdlSumaTotalMaterial($tabla, $id_solicitud);
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud en USD
          $sumaDlls = ModeloSolicitudes::mdlSumaTotalMaterialDlls($tabla, $id_solicitud);
          #actualizar el campo de total
          $tbl = "tbl_solicitudes";
          $data = array('id_solicitud' => $id_solicitud,
                        'soli_sumatoria_materiales' => $suma['total'],
                        'soli_sumatoria_materiales_dlls' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $cantidad);
          $sumTotalMaterial = ModeloSolicitudes::mdlActualizarTotalesMaterial($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesSolicitud == "ok") {
              return "ok";
          }
        }else{
          return $respuesta;
        }

    }
    /*=============================================
      FINALIZAR EL LLENADO DEL APARTADO DE MATERIALESS
    =============================================*/
    public static function ctrFinApartadoMateriales($valor){
        $tabla = "tbl_solicitudes";
        $true = 1;
        $array = array('id_solicitud' => $valor,
                      'soli_termina_materiales' => $true);
        $respuesta = ModeloSolicitudes::mdlFinalizarApartadoMateriales($tabla,$array);

        return $respuesta;
    }
    /*=============================================
      EDITAR PARTIDA DE  MANO DE OBRA WHERE id_mano_de_obra
    =============================================*/
    static public function ctrEditarManoDeObraAjax($datos){
        $tabla = "tbl_mano_de_obra";
        $respuestaDetalle = ModeloSolicitudes::mdlEditManoDeObra($tabla, $datos);

        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud
          $suma = ModeloSolicitudes::mdlSumaTotalManoDeObra($tabla, $datos['fk_id_solicitud']);
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud DLLS
          $sumaDlls = ModeloSolicitudes::mdlSumaTotalManoDeObraDlls($tabla, $datos['fk_id_solicitud']);
          $sumaHrs = ModeloSolicitudes::mdlSumaTotalHrs($tabla, $datos['fk_id_solicitud']);
          #actualizar el campo de total
          $tbl = "tbl_solicitudes";
          $data = array('id_solicitud' => $datos['fk_id_solicitud'],
                        'soli_sumatoria_manoDeObra' => $suma['total'],
                        'soli_sumatoria_manoDeObra_dlls' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $datos['soli_cantidad_piezas'],
                        'soli_sumInd_hrsUnitarias' => $sumaHrs['cantidad']);
          $sumTotalMaterial = ModeloSolicitudes::mdlActualizarTotalesManoDeObra($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotalesDlls($tbl,$data);

          if ($sumaTotalesSolicitud == "ok") {
              return "EditOK";
          }
        }
    }
    /*=============================================
      INSERTAR MATERIALES X SOLICITUD
    =============================================*/
    static public function ctrInsertarManoDeObraAjax($datos){
        $tabla = "tbl_mano_de_obra";
        $respuestaDetalle = ModeloSolicitudes::mdlInsertarManoDeObra($tabla, $datos);

        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud MXN
          $suma = ModeloSolicitudes::mdlSumaTotalManoDeObra($tabla, $datos['fk_id_solicitud']);
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud DLLS
          $sumaDlls = ModeloSolicitudes::mdlSumaTotalManoDeObraDlls($tabla, $datos['fk_id_solicitud']);

          $sumaHrs = ModeloSolicitudes::mdlSumaTotalHrs($tabla, $datos['fk_id_solicitud']);
          #actualizar el campo de total
          $tbl = "tbl_solicitudes";
          $data = array('id_solicitud' => $datos['fk_id_solicitud'],
                        'soli_sumatoria_manoDeObra' => $suma['total'],
                        'soli_sumatoria_manoDeObra_dlls' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $datos['soli_cantidad_piezas'],
                        'soli_sumInd_hrsUnitarias' => $sumaHrs['cantidad']);
          $sumTotalMaterial = ModeloSolicitudes::mdlActualizarTotalesManoDeObra($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesSolicitud == "ok") {
              return "insert";
          }
        }
    }
    /*=============================================
      GET DATOS DE MANO DE OBRA
    =============================================*/
    public static function ctrGetManoDeObra($item,$valor){
        $tabla = "tbl_mano_de_obra";
        $respuesta = ModeloSolicitudes::mdlMostrarManoDeObra($tabla,$item,$valor);
        return $respuesta;
    }
    /*=============================================
      GET A datos de mano de obra wherre id
    =============================================*/
    public static function ctrGetManoDeObraWhereId($item,$valor){
        $tabla = "tbl_mano_de_obra";
        $respuesta = ModeloSolicitudes::mdlMostrarManoDeObraWhereID($tabla,$item,$valor);
        return $respuesta;
    }
    /*=============================================
      ELIMINAR MANO DE OBRA WHERE ID
    =============================================*/
    public static function ctrDeleteManoDeObra($item,$id_solicitud, $id_material, $cantidad){
        $tabla = "tbl_mano_de_obra";
        $respuesta = ModeloSolicitudes::mdlDeleteManoDeObra($tabla,$id_material);
        if ($respuesta == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud
          $suma = ModeloSolicitudes::mdlSumaTotalManoDeObra($tabla, $id_solicitud);
          #actualizar el campo de total
          $sumaDlls = ModeloSolicitudes::mdlSumaTotalManoDeObraDlls($tabla, $id_solicitud);
          $sumaHrs = ModeloSolicitudes::mdlSumaTotalHrs($tabla, $id_solicitud);
          $tbl = "tbl_solicitudes";
          $data = array('id_solicitud' => $id_solicitud,
                        'soli_sumatoria_manoDeObra' => $suma['total'],
                        'soli_sumatoria_manoDeObra_dlls' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $cantidad,
                        'soli_sumInd_hrsUnitarias' => $sumaHrs['cantidad']);
          $sumTotalMaterial = ModeloSolicitudes::mdlActualizarTotalesManoDeObra($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesSolicitud == "ok") {
              return "ok";
          }
        }else{
          return $respuesta;
        }
    }
    /*=============================================
      FINALIZAR EL LLENADO DEL APARTADO DE MANO DE OBRA
    =============================================*/
    public static function ajaxFinalizarManoDeObra($valor){
        $tabla = "tbl_solicitudes";
        $true = 1;
        $array = array('id_solicitud' => $valor,
                      'soli_termina_manoDeObra' => $true);
        $respuesta = ModeloSolicitudes::mdlFinalizarApartadoManoDeObra($tabla,$array);

        return $respuesta;
    }
    /*=============================================
      EDITAR PARTIDA DE  MANO DE OBRA WHERE id_mano_de_obra
    =============================================*/
    static public function ctrEditarIndirectosAjax($datos){
        $tabla = "tbl_gastos_indirectos";
        $respuestaDetalle = ModeloSolicitudes::mdlEditIndirectos($tabla, $datos);

        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud
          $suma = ModeloSolicitudes::mdlSumaTotalIndirectos($tabla, $datos['fk_id_solicitud']);
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud en USD
          $sumaDlls = ModeloSolicitudes::mdlSumaTotalIndirectosDlls($tabla, $datos['fk_id_solicitud']);
          #actualizar el campo de total
          $tbl = "tbl_solicitudes";
          $data = array('id_solicitud' => $datos['fk_id_solicitud'],
                        'soli_sumatoria_indirectos' => $suma['total'],
                        'soli_sumatoria_indirectos_dlls' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);
          $sumTotalMaterial = ModeloSolicitudes::mdlActualizarTotalesIndirectos($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesSolicitud == "ok") {
              return "EditOK";
          }
        }
    }
    /*=============================================
      INSERTAR MATERIALES X SOLICITUD
    =============================================*/
    static public function ctrInsertarIndirectosAjax($datos){
        $tabla = "tbl_gastos_indirectos";
        $respuestaDetalle = ModeloSolicitudes::mdlInsertarIndirectos($tabla, $datos);

        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud
          $suma = ModeloSolicitudes::mdlSumaTotalIndirectos($tabla, $datos['fk_id_solicitud']);
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud en USD
          $sumaDlls = ModeloSolicitudes::mdlSumaTotalIndirectosDlls($tabla, $datos['fk_id_solicitud']);
          #actualizar el campo de total
          $tbl = "tbl_solicitudes";
          $data = array('id_solicitud' => $datos['fk_id_solicitud'],
                        'soli_sumatoria_indirectos' => $suma['total'],
                        'soli_sumatoria_indirectos_dlls' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);

          $sumTotalMaterial = ModeloSolicitudes::mdlActualizarTotalesIndirectos($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesSolicitud == "ok") {
              return "insert";
          }
        }
    }
    /*=============================================
      GET DATOS INDIRECTOS
    =============================================*/
    public static function ctrGetIndirectos($item,$valor){
        $tabla = "tbl_gastos_indirectos";
        $respuesta = ModeloSolicitudes::mdlMostrarIndirectos($tabla,$item,$valor);
        return $respuesta;
    }
    /*=============================================
      ELIMINAR MANO DE OBRA WHERE ID
    =============================================*/
    public static function ctrDeleteIndirectos($item,$id_solicitud, $id_material, $cantidad){
        $tabla = "tbl_gastos_indirectos";
        $respuesta = ModeloSolicitudes::mdlDeleteIndirectos($tabla,$id_material);
        if ($respuesta == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud
          $suma = ModeloSolicitudes::mdlSumaTotalIndirectos($tabla, $id_solicitud);
          $sumaDlls = ModeloSolicitudes::mdlSumaTotalIndirectosDlls($tabla, $id_solicitud);
          #actualizar el campo de total
          $tbl = "tbl_solicitudes";
          $data = array('id_solicitud' => $id_solicitud,
                        'soli_sumatoria_indirectos' => $suma['total'],
                        'soli_sumatoria_indirectos_dlls' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $cantidad);
          $sumTotalMaterial = ModeloSolicitudes::mdlActualizarTotalesIndirectos($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
         $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotalesDlls($tbl,$data);

          if ($sumaTotalesSolicitud == "ok") {
              return "ok";
          }
        }else{
          return $respuesta;
        }
    }
    /*=============================================
      FINALIZAR EL LLENADO DEL APARTADO indirectos
    =============================================*/
    public static function ctrlFinalizarIndirectos($valor){
        $tabla = "tbl_solicitudes";
        $true = 1;
        $array = array('id_solicitud' => $valor,
                      'soli_termina_indirectos' => $true);
        $respuesta = ModeloSolicitudes::mdlFinalizarApartadoIndirectos($tabla,$array);
        return $respuesta;
    }
    /*=============================================
      GET A datos de gastos indirectos
    =============================================*/
    public static function ctrGetIndirectosWhereId($item,$valor){
        $tabla = "tbl_gastos_indirectos";
        $respuesta = ModeloSolicitudes::mdlMostrarIndirectosWhereID($tabla,$item,$valor);
        return $respuesta;
    }
    /*=============================================
      EDITAR PARTIDA DE EXTERNOS WHERE  id_gasto_externo
    =============================================*/
    static public function ctrEditarExternosAjax($datos){
        $tabla = "tbl_gastos_externos";
        $respuestaDetalle = ModeloSolicitudes::mdlEditExternos($tabla, $datos);

        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud
          $suma = ModeloSolicitudes::mdlSumaTotalExternos($tabla, $datos['fk_id_solicitud']);
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud en USD
          $sumaDlls = ModeloSolicitudes::mdlSumaTotalExternoslDlls($tabla, $datos['fk_id_solicitud']);
          #actualizar el campo de total
          $tbl = "tbl_solicitudes";
          $data = array('id_solicitud' => $datos['fk_id_solicitud'],
                        'soli_sumatoria_externos' => $suma['total'],
                        'soli_sumatoria_externos_dlls' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);

          $sumTotalMaterial = ModeloSolicitudes::mdlActualizarTotalesExternos($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesSolicitud == "ok") {
              return "EditOK";
          }
        }
    }
    /*=============================================
      INSERTAR APARTADO EXTERNOS X SOLICITUD
    =============================================*/
    static public function ctrInsertarExternosAjax($datos){
        $tabla = "tbl_gastos_externos";
        $respuestaDetalle = ModeloSolicitudes::mdlInsertarExternos($tabla, $datos);

        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud
          $suma = ModeloSolicitudes::mdlSumaTotalExternos($tabla, $datos['fk_id_solicitud']);
          $sumaDlls = ModeloSolicitudes::mdlSumaTotalExternoslDlls($tabla, $datos['fk_id_solicitud']);

          #actualizar el campo de total
          $tbl = "tbl_solicitudes";
          $data = array('id_solicitud' => $datos['fk_id_solicitud'],
                        'soli_sumatoria_externos' => $suma['total'],
                        'soli_sumatoria_externos_dlls' => $sumaDlls['total'],
                        'soli_cantidad_piezas' => $datos['soli_cantidad_piezas']);
          $sumTotalMaterial = ModeloSolicitudes::mdlActualizarTotalesExternos($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesSolicitud == "ok") {
              return "insert";
          }
        }
    }
    /*=============================================
      GET DATOS EXTERNOS
    =============================================*/
    public static function ctrGetExternos($item,$valor){
        $tabla = "tbl_gastos_externos";
        $respuesta = ModeloSolicitudes::mdlMostrarExternos($tabla,$item,$valor);
        return $respuesta;
    }
    /*=============================================
      GET A datos de gastos EXTERNOS
    =============================================*/
    public static function ctrGetExternosWhereId($item,$valor){
        $tabla = "tbl_gastos_externos";
        $respuesta = ModeloSolicitudes::mdlMostrarExternosWhereID($tabla,$item,$valor);
        return $respuesta;
    }
    /*=============================================
      ELIMINAR EXTERNOS WHERE ID
    =============================================*/
    public static function ctrDeleteExternos($item,$id_solicitud, $id_material,$cantidad){
        $tabla = "tbl_gastos_externos";
        $respuesta = ModeloSolicitudes::mdlDeleteExternos($tabla,$id_material);
        if ($respuesta == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud
          $suma = ModeloSolicitudes::mdlSumaTotalExternos($tabla, $id_solicitud);
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud en USD
          $sumaDlls = ModeloSolicitudes::mdlSumaTotalExternoslDlls($tabla, $id_solicitud);
          #actualizar el campo de total
          $tbl = "tbl_solicitudes";
          $data = array('id_solicitud' => $id_solicitud,
                        'soli_sumatoria_externos' => $suma['total'],
                        'soli_sumatoria_externos_dlls' => $sumaDlls['total'],
                       'soli_cantidad_piezas' => $cantidad);
          $sumTotalMaterial = ModeloSolicitudes::mdlActualizarTotalesExternos($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotales($tbl,$data);
          #Sumatoria de los totales de cada apartado EN DLLS
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotalesDlls($tbl,$data);
          if ($sumaTotalesSolicitud == "ok") {
              return "ok";
          }
        }else{
          return $respuesta;
        }
    }
    /*=============================================
      FINALIZAR EL LLENADO DEL APARTADO DE EXTERNOS
    =============================================*/
    public static function ctrFinalizarExternos($valor){
        $tabla = "tbl_solicitudes";
        $true = 1;
        $array = array('id_solicitud' => $valor,
                      'soli_termina_externos' => $true);
        $respuesta = ModeloSolicitudes::mdlFinalizarApartadoExternos($tabla,$array);

        return $respuesta;
    }
    /*=============================================
      CAMBIA EL STATUS DEL CAMPO solo_termina_materiales a 0
    =============================================*/
    public static function ctrReactivarMateriales($valor){
        $tabla = "tbl_solicitudes";
        $true = 0;
        $array = array('id_solicitud' => $valor,
                      'soli_termina_materiales' => $true);
        $respuesta = ModeloSolicitudes::mdlFinalizarApartadoMateriales($tabla,$array);

        return $respuesta;
    }
    /*=============================================
      CAMBIA EL STATUS DEL CAMPO solo_termina_materiales a 0
    =============================================*/
    public static function ctrReactivarManoDeObra($valor){
        $tabla = "tbl_solicitudes";
        $true = 0;
        $array = array('id_solicitud' => $valor,
                      'soli_termina_manoDeObra' => $true);
        $respuesta = ModeloSolicitudes::mdlFinalizarApartadoManoDeObra($tabla,$array);

        return $respuesta;
    }
    /*=============================================
      CAMBIA EL STATUS DEL CAMPO soli_termina_indirectos a 0
    =============================================*/
    public static function ctrReactivarIndirectos($valor){
        $tabla = "tbl_solicitudes";
        $true = 0;
        $array = array('id_solicitud' => $valor,
                      'soli_termina_indirectos' => $true);
        $respuesta = ModeloSolicitudes::mdlFinalizarApartadoIndirectos($tabla,$array);
        return $respuesta;
    }
    /*=============================================
      CAMBIA EL STATUS DEL CAMPO soli_termina_externos a 0
    =============================================*/
    public static function ctrReactivarExternos($valor){
        $tabla = "tbl_solicitudes";
        $true = 0;
        $array = array('id_solicitud' => $valor,
                      'soli_termina_externos' => $true);
        $respuesta = ModeloSolicitudes::mdlFinalizarApartadoExternos($tabla,$array);
        return $respuesta;
    }
    /*=============================================
      Verifica que todos los apartados de la solicitud se encuetren en 1
    =============================================*/
    public static function ctrVerificarStatusDeTerminacion($valor){
        $tabla = "tbl_solicitudes";
        $true = 0;
        $respuesta = ModeloSolicitudes::mdlVerificarStatusDeTerminacion($tabla,$valor);
        return $respuesta;
    }
    /*=============================================
      CAMBIA EL STATUS DE LA SOLICITUD
    =============================================*/
    public static function ctrFinalizarSolicitud($valor){
        $tabla = "tbl_solicitudes";
        $status = 10;
        $array = array('id_solicitud' => $valor,
                      'fk_id_status' => $status);
        $respuesta = ModeloSolicitudes::mdlActualizarStatusDeSolicitudAFinalizado($tabla,$array);
        return $respuesta;
    }
    /*=============================================
      CAMBIA EL STATUS DE LA SOLICITUD A RECHAZADO
    =============================================*/
    public static function ctrRechazrSolicitud($valor){
        $tabla = "tbl_solicitudes";
        $status = 3;
        $array = array('id_solicitud' => $valor,
                      'fk_id_status' => $status);
        $respuesta = ModeloSolicitudes::mdlActualizarStatusDeSolicitudAFinalizado($tabla,$array);
        return $respuesta;
    }
    /*=============================================
      CAMBIA EL STATUS DE LA SOLICITUD A RECHAZADO
    =============================================*/
    public static function ctrAprobarSolicitudCoordinador($valor){
        $tabla = "tbl_solicitudes";
        $status = 4;
        $array = array('id_solicitud' => $valor,
                      'fk_id_status' => $status);
        $respuesta = ModeloSolicitudes::mdlActualizarStatusDeSolicitudAFinalizado($tabla,$array);
        return $respuesta;
    }
    /*=============================================
      EDITAR PARTIDA DE CONCEPTOS WHERE  id_concepto
    =============================================*/
    static public function ctrEditarConceptosAjax($datos){
        $tabla = "tbl_conceptos";
        $respuestaDetalle = ModeloSolicitudes::mdlEditConceptos($tabla, $datos);

        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud
          $suma = ModeloSolicitudes::mdlSumaTotalConceptos($tabla, $datos['fk_id_solicitud']);
          #actualizar el campo de total
          $tbl = "tbl_solicitudes";
          $data = array('id_solicitud' => $datos['fk_id_solicitud'],
                        'soli_totalFinal' => $suma['total']);
          $sumTotalMaterial = ModeloSolicitudes::mdlActualizarTotalesConceptos($tbl,$data);
          #Sumatoria de los totales de cada apartado
      //    $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotales($tbl,$data);
          if ($sumTotalMaterial == "ok") {
              return "EditOK";
          }
          else {
            return $sumTotalMaterial;
          }
        }
    }
    /*=============================================
      INSERTAR APARTADO EXTERNOS X SOLICITUD
    =============================================*/
    static public function ctrInsertarConceptosAjax($datos){
        $tabla = "tbl_conceptos";
        $respuestaDetalle = ModeloSolicitudes::mdlInsertarConceptos($tabla, $datos);

        if ($respuestaDetalle == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud
          $suma = ModeloSolicitudes::mdlSumaTotalConceptos($tabla, $datos['fk_id_solicitud']);
          $sumaDlls = ModeloSolicitudes::mdlSumaTotalConceptosUSD($tabla, $datos['fk_id_solicitud']);
          #actualizar el campo de total
          $tbl = "tbl_solicitudes";
          $data = array('id_solicitud' => $datos['fk_id_solicitud'],
                        'soli_totalFinal' => $suma['total'],
                        'soli_totalFinal_dlls' => $sumaDlls['total']);
          $sumTotalMaterial = ModeloSolicitudes::mdlActualizarTotalesConceptos($tbl,$data);
          #Sumatoria de los totales de cada apartado
        //  $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotales($tbl,$data);
          if ($sumTotalMaterial == "ok") {
              return "insert";
          }
          else {
            return $sumTotalMaterial;
          }
        }
        else {
            return $respuestaDetalle;
        }
    }
    /*=============================================
      GET DATOS CONCEPTOS
    =============================================*/
    public static function ctrGetConceptos($item,$valor){
        $tabla = "tbl_conceptos";
        $respuesta = ModeloSolicitudes::mdlMostrarConceptos($tabla,$item,$valor);
        return $respuesta;
    }
    /*=============================================
      ELIMINAR EXTERNOS WHERE ID
    =============================================*/
    public static function ctrDeleteConceptos($item,$id_solicitud, $id_material){
        $tabla = "tbl_conceptos";
        $respuesta = ModeloSolicitudes::mdlDeleteConceptos($tabla,$id_material);
        if ($respuesta == "ok") {
          #select a la taba de materiales para obtener la sumatoria de todos los materiales de id_solicitud
          $suma = ModeloSolicitudes::mdlSumaTotalConceptos($tabla, $id_solicitud);
          #actualizar el campo de total
          $tbl = "tbl_solicitudes";
          $data = array('id_solicitud' => $id_solicitud,
                        'soli_sumatoria_conceptos' => $suma['total']);
          $sumTotalMaterial = ModeloSolicitudes::mdlActualizarTotalesConceptos($tbl,$data);
          #Sumatoria de los totales de cada apartado
          $sumaTotalesSolicitud  = ModeloSolicitudes::mdlSumatoriaDeTotales($tbl,$data);
          if ($sumaTotalesSolicitud == "ok") {
              return "ok";
          }
        }else{
          return $respuesta;
        }
    }
    /*=============================================
      GET A datos de gastos CONCEPTOS
    =============================================*/
    public static function ctrGetConceptosWhereId($item,$valor){
        $tabla = "tbl_conceptos";
        $respuesta = ModeloSolicitudes::mdlMostrarConceptosWhereID($tabla,$item,$valor);
        return $respuesta;
    }
    /*=============================================
      GET A datos de gastos CONCEPTOS
    =============================================*/
    public static function ctrGetConceptosWhereIdAll($item,$valor){
        $tabla = "tbl_conceptos";
        $respuesta = ModeloSolicitudes::mdlMostrarConceptosWhereIDAll($tabla,$item,$valor);
        return $respuesta;
    }
    /*=============================================
      SE ACTUALIZAN LOS CAMPOS DE TOTALES
    =============================================*/
    public static function ctrActualizarTotalesSoli($array){
        $tabla = "tbl_solicitudes";
        $respuesta = ModeloSolicitudes::mdlActualizarTotalesSolicitud($tabla,$array);
        return $respuesta;
    }
    /*=============================================
      CAMBIA EL STATUS DE LA SOLICITUD
    =============================================*/
    public static function ctrEnviarAAprobacion($valor){
        $tabla = "tbl_solicitudes";
        $status = 5;
        $array = array('id_solicitud' => $valor,
                      'fk_id_status' => $status);
        $respuesta = ModeloSolicitudes::mdlActualizarAFinalizado($tabla,$array);
        return $respuesta;
    }

    /*=============================================
    INGRESO DE RESPONSABLE DE SOLICITUD
    =============================================*/
    static public function ctrIngresarResponsable(){
      if (isset($_POST["nuevoResponsable"])) {
          $tabla = "tbl_solicitudes";
          $array = array('id_solicitud' => $_POST['id_solicitud_'],
                        'soli_responsable' => $_POST['nuevoResponsable']);
          $respuesta = ModeloSolicitudes::mdlActualizarResponsable($tabla,$array);
          if ($respuesta == "ok") {
            echo '<script>
              swal({
                type: "success",
                title: "¡El responsable se asignó correctamente!",
                showConfirmButton: true,
                confirmButtonText: "Cerrar"
              }).then(function(result){
                if(result.value){
                  window.location = "solicitudes";
                }
              });
            </script>';
          }else {
            echo '<script>
              swal({
                type: "error",
                title: "¡Error al asignar el responsable!",
                showConfirmButton: true,
                confirmButtonText: "Cerrar"

              }).then(function(result){
                if(result.value){
                }
              });
            </script>';
          }
      }
    }
    /*=============================================
      CAMBIA EL STATUS DE LA SOLICITUD
    =============================================*/
    public static function ctrAprobarSolicitud($array){
        $tabla = "tbl_solicitudes";
        $respuesta = ModeloSolicitudes::mdlActualizarAFinalizado($tabla,$array);
        return $respuesta;
    }
    /*=============================================
      CAMBIA EL STATUS DE LA SOLICITUD
    =============================================*/
    public static function ctrRechazarSolicitud($array){
        $tabla = "tbl_solicitudes";
        $respuesta = ModeloSolicitudes::mdlRechazarSolicitud($tabla,$array);
        return $respuesta;
    }
    public static function ctrCancelarSolicitud($array){
        $tabla = "tbl_solicitudes";
        $respuesta = ModeloSolicitudes::mdlCancelarSolicitud($tabla,$array);
        return $respuesta;
    }
    public static function ctrGuardarNotasCotizacion($array){
        $tabla = "tbl_solicitudes";
        $respuesta = ModeloSolicitudes::mdlActualizarNotasCotizacion($tabla,$array);
        return $respuesta;
    }
    /*=============================================
    CAMBIAR STATUS DE COTIZACION 'enviada'
  =============================================*/
    static public function ctrCambiarStausSolicitud($idSoli,$status,$enviadoA,$correo,$empresa){
            /*=============================================
                GENERA LA FECHA Y HORA ACTUAL PARA SABER CUANDO SE INSERTO
            =============================================*/
            date_default_timezone_set("US/Central");
            $fecha = date('Y-m-d');
            $hora = date('H:i:s');
            $fechaActual = $fecha.' '.$hora;
            $tabla = "tbl_solicitudes";

            $detalles = array('id_solicitud' => $idSoli,
                              'fk_id_status' => $status);
             $respuesta = ModeloSolicitudes::mdlActualizarAFinalizado($tabla, $detalles);
            if ($respuesta == "ok") {
              $tabla1 = "tbl_historial_envios";
                $detalles1 = array('historial_enviadoA' => $enviadoA,
                              'historial_correo' => $correo,
                              'historial_fecha' => $fechaActual,
                              'historial_empresa' => $empresa,
                                  'fk_id_solicitud' => $idSoli);
                $respuestaEnvio = ModeloSolicitudes::mdlInsertarEnvioaHistorial($tabla1, $detalles1);

            }
    }

    public static function ctrGuardarNombreDeArchivo($array){
        $tabla = "tbl_adjuntos";
        $respuesta = ModeloSolicitudes::mdlInsertarNombreArchivo($tabla,$array);
        return $respuesta;
    }
    /*=============================================
    MOSTRAR LISTADO DE SOLICITUDES
    =============================================*/
    public static function ctrGetNameFile($item,$valor){
        $tabla = "tbl_adjuntos";
        $respuesta = ModeloSolicitudes::mdlMostrarNameFile($tabla,$item,$valor);
        return $respuesta;
    }
    public static function ctrEliminarAdjunto($array){
        $tabla = "tbl_adjuntos";
        $respuesta = ModeloSolicitudes::mdlEliminarAdjunto($tabla,$array);
        return $respuesta;
    }
    /*=============================================
      SE ACTUALIZAN LOS CAMPOS DE TOTALES
    =============================================*/
    public static function ctrGuardarTiempoEntrega($array){
        $tabla = "tbl_solicitudes";
        $respuesta = ModeloSolicitudes::mdlActualizarTiempoEntregaAdmin($tabla,$array);
        return $respuesta;
    }
    /*=============================================
      SE ACTUALIZAN EL TIPO DE MONEDA DE LA SOLICITUD
    =============================================*/
    public static function ctrCambiarTipoMoneda($array){
        $tabla = "tbl_solicitudes";
        $respuesta = ModeloSolicitudes::mdlActualizarTipoMoneda($tabla,$array);
        return $respuesta;
    }
    /*=============================================
      OBTENER EL HISTORIAL DE CORREOS ENVIADOS X CLIENTE
    =============================================*/
    public static function ctrGetHistorialCorreos($item,$valor){
        $tabla = "tbl_historial_envios";
        $respuesta = ModeloSolicitudes::mdlGetHistorialCorreos($tabla,$item,$valor);
        return $respuesta;
    }
    /*=============================================
      GET TIPOS DE FORMAS DE APROBACION
    =============================================*/
    public static function ctrGetFormasDeAprobacion($item,$valor){
        $tabla = "cat_formas_aprobacion";
        $respuesta = ModeloSolicitudes::mdlGetFormasDeAprobacion($tabla,$item,$valor);
        return $respuesta;
    }
    /*=============================================
      GET TIPOS DE FORMAS DE APROBACION
    =============================================*/
    public static function ctrConvertirAFolio($array){
        $tabla = "tbl_solicitudes";
        $respuesta = ModeloSolicitudes::mdlConvertirAFolio($tabla,$array);
          return $respuesta;
    }
    /*=============================================
      CAMBIA EL STATUS DE LA SOLICITUD
    =============================================*/
    public static function ctrEnviarAVentas($valor){
        $tabla = "tbl_solicitudes";
        $status = 3;
        $array = array('id_solicitud' => $valor,
                      'fk_id_status' => $status);
        $respuesta = ModeloSolicitudes::mdlActualizarStatusDeSolicitudAFinalizado($tabla,$array);
        return $respuesta;
    }
    /*=============================================
      ACTUALIZAR EL TITULO DE LA SOLICITUD
    =============================================*/
    public static function ctrUpdateTituloSoli($datos){
      $tabla = "tbl_solicitudes";
      $respuesta = ModeloSolicitudes::mdlUpdateTituloSoli($tabla,$datos);
      return $respuesta;
    }
    public static function ctrGetCancelaciones(){
        $tabla = "cat_cancelaciones";
        $respuesta = ModeloSolicitudes::mdlMostrarCancelaciones($tabla);
        return $respuesta;
    }
    public static function ctrUpdateFechaVisita($datos){
        $tabla = "tbl_solicitudes";
        $respuesta = ModeloSolicitudes::mdlUpdateFechaVisita($tabla,$datos);
        return $respuesta;
    }
    public static function ctrHistorialMovimientos($array){
      $tabla = "tbl_movimientos_solicitud";
      $respuesta = ModeloSolicitudes::mdlInsertarMovimiento($tabla,$array);
      return $respuesta;
    }
    public static function ctrGetHistorySoli($item,$valor){
        $tabla = "tbl_movimientos_solicitud";
        $respuesta = ModeloSolicitudes::mdlGetHistorySoli($tabla,$item,$valor);
        return $respuesta;
    }
    public static function ctrUpdateNoOC($datos){
        $tabla = "tbl_solicitudes";
        $respuesta = ModeloSolicitudes::mdlUpdateNoOC($tabla,$datos);
        return $respuesta;
    }
    public static function ctrconfirmarRecepcion($datos){
        $tabla = "tbl_solicitudes";
        $respuesta = ModeloSolicitudes::mdlconfirmarRecepcion($tabla,$datos);
        return $respuesta;
    }
    public static function ctrMostrarStatus($item,$valor){
        $tabla = "cat_status_solicitud";
        $respuesta = ModeloSolicitudes::mdlGetStatus($tabla,$item,$valor);
        return $respuesta;
    }
    public static function ctrMostrarResponsable($item,$valor){
        $tabla = "tab_usuarios";
        $respuesta = ModeloSolicitudes::mdlGetVendedores($tabla,$item,$valor);
        return $respuesta;
    }
    public static function ctrGetSolicitudesAjax($item,$value){
        $tabla = "tbl_solicitudes";
        $respuesta = ModeloSolicitudes::mdlMostrarSolicitudes_($tabla,$item,$value);
        return $respuesta;
    }

}

 ?>
