<?php
  /**
   * By Urie
   */
  require_once "conexion.php";
  class ModeloCompras{
    /*=============================================
        OBTENER TODAS LAS PARTIDAS DE MATERIALES CON STATUS DE APROBADO
    =============================================*/
    static public function mdlGetMaterialAprobado($tabla,$item,$valor){

      if ($item !== null && $item !== "id_requi_material" ) {
        $stmt = conexion::conectar()->prepare("SELECT * FROM $tabla AS M inner join tbl_folios as F on M.fk_id_folio = F.id_folio where requiM_status = 'Aprobado' and M.fk_id_folio = $valor");
        $stmt ->execute();
        return $stmt ->fetchall();
      }elseif ($item == "id_requi_material") {

        $stmt = conexion::conectar()->prepare("SELECT * FROM $tabla  where id_requi_material = $valor");
        $stmt ->execute();
        return $stmt ->fetchall();
      }
      else {
        $stmt = conexion::conectar()->prepare("SELECT * FROM $tabla AS M inner join tbl_folios as F on M.fk_id_folio = F.id_folio where requiM_status = 'Aprobado'");
        $stmt ->execute();
        return $stmt ->fetchall();
      }
      $stmt->close();
      $stmt=null;
    }
    /*=============================================
        SE OBTIENEN EL LISTADO DE DIVISAS cat_divisas
    =============================================*/
    static public function mdlGetDivisas($tabla,$item,$valor){
      if ($item !== null) {
        $stmt = conexion::conectar()->prepare("SELECT * FROM $tabla AS D where D.id_moneda = $valor");
        $stmt ->execute();
        return $stmt ->fetchall();
      }else {
        $stmt = conexion::conectar()->prepare("SELECT * FROM $tabla");
        $stmt ->execute();
        return $stmt ->fetchall();
      }
      $stmt->close();
      $stmt=null;
    }
    /*=============================================
        SE OBTIENEN EL LISTADO DE DIVISAS cat_divisas
    =============================================*/
    static public function mdlGetContacto($tabla,$item,$valor){
      if ($item !== null) {
        $stmt = conexion::conectar()->prepare("SELECT * FROM $tabla AS C inner join cat_proveedores as P on C.id_proveedor = P.id_proveedor where C.$item = :$item");
        $stmt -> bindParam(":".$item,$valor, PDO::PARAM_STR);
        $stmt ->execute();
        return $stmt ->fetchall();
      }
      $stmt->close();
      $stmt=null;
    }
    /*=============================================
        GUARDAR NUEVA ORDEN DE COMPRA Y RETORNAR EL ID INSERTADO
    =============================================*/
    static public function mdlSaveOC($tabla,$datos){

      try {
        #Se Obtiene el ultimo folio insertado
        $ultimoFolio = ModeloCompras::mdlGetUltimoFolioOC();
       $stmt = Conexion::conectar()->prepare("INSERT INTO $tabla (oc_folio, id_proveedor, fk_id_contacto, fk_id_divisa, oc_observaciones, fk_id_statusOC, oc_fecha_creado) VALUES (:oc_folio,:id_proveedor, :fk_id_contacto, :fk_id_divisa, :oc_observaciones, :fk_id_statusOC, :oc_fecha_creado)");
       $stmt->bindParam(":oc_folio", $ultimoFolio, PDO::PARAM_STR);
       $stmt->bindParam(":id_proveedor", $datos["id_proveedor"], PDO::PARAM_STR);
       $stmt->bindParam(":fk_id_contacto", $datos["fk_id_contacto"], PDO::PARAM_STR);
       $stmt->bindParam(":fk_id_divisa", $datos["fk_id_divisa"], PDO::PARAM_STR);
       $stmt->bindParam(":oc_observaciones", $datos["oc_observaciones"], PDO::PARAM_STR);
       $stmt->bindParam(":fk_id_statusOC", $datos["fk_id_statusOC"], PDO::PARAM_STR);
       $stmt->bindParam(":oc_fecha_creado", $datos["oc_fecha_creado"], PDO::PARAM_STR);
       if($stmt->execute()){
         $item = "oc_folio";
         $id = ModeloCompras::mdlMostrarLastId($item, $ultimoFolio);
         $resp = array('msj' => "ok",
                       'id_ordenCompra' => $id);
         return $resp;
       }else{
         return  $stmt -> errorInfo();
       }
       $stmt->close();
       $stmt = null;
      } catch (PDOException $e) {
        var_dump($e);
      }
    }
    static public function mdlGetUltimoFolioOC(){
      $stmt = conexion::conectar()->prepare("SELECT SUBSTRING(oc_folio, -2) terminacion FROM tbl_ordenescompra order by id_ordenCompra desc  limit 1");
      $stmt->execute();
      $resultado = $stmt ->fetch();
        if($resultado != false){
                $year = date("y");
                $month = date("m");
                $Result =  (int) $resultado['terminacion'];
                $Result = $Result + 1;
                if ($Result < 10) {
                  $Nuevo = (string) $Result;
                  $Nuevo = "OC"."$year"."$month"."0".$Nuevo;
                  return $Nuevo;
                }else {
                  $Nuevo = (string) $Result;
                  $Nuevo = "OC"."$year"."$month".$Nuevo;
                  return $Nuevo;
                }
        }
        else{
            $year = date("y");
            $month = date("m");
            $Nuevo = "OC"."$year"."$month". "01";
            return $Nuevo;
        }
        $stmt->close();
        $stmt=null;
    }
    static public function mdlMostrarLastId($item,$valor){
        if ($item != null) {
          $stmt = conexion::conectar()->prepare("SELECT id_ordenCompra FROM tbl_ordenescompra WHERE $item = :$item ");
          $stmt -> bindParam(":".$item,$valor, PDO::PARAM_STR);
          $stmt ->execute();
          return $stmt ->fetch();
        }
        $stmt->close();
        $stmt=null;
    }
    static public function mdlSaveOCDetalles($tabla,$datos){

      $stmt = Conexion::conectar()->prepare("INSERT INTO $tabla (fk_id_OC, fk_id_RequiMat) VALUES (:fk_id_OC, :fk_id_RequiMat)");
      $stmt->bindParam(":fk_id_OC", $datos["fk_id_OC"], PDO::PARAM_STR);
      $stmt->bindParam(":fk_id_RequiMat", $datos["fk_id_RequiMat"], PDO::PARAM_STR);
      if($stmt->execute()){
        return "ok";
      }else{
        return  $stmt -> errorInfo();
      }
      $stmt->close();
      $stmt = null;
    }
    static public function mdlUpdateSubTotal($tabla,$datos){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET oc_subtotal = :oc_subtotal WHERE id_ordenCompra = :id_ordenCompra");
        $stmt->bindParam(":id_ordenCompra", $datos["id_ordenCompra"], PDO::PARAM_STR);
        $stmt->bindParam(":oc_subtotal", $datos["oc_subtotal"], PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlUpdateStatusPartida($tabla,$datos){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET requiM_status = :requiM_status WHERE id_requi_material = :id_requi_material");
        $stmt->bindParam(":id_requi_material", $datos["id_requi_material"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_status", $datos["requiM_status"], PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    /*=============================================
        SE OBTIENEN EL LISTADO DE DIVISAS cat_divisas
    =============================================*/
    static public function mdlGetOC($tabla,$item,$valor){
      if ($item !== null) {
        $stmt = conexion::conectar()->prepare("SELECT * FROM $tabla AS OC inner join cat_proveedores as P on OC.id_proveedor = P.id_proveedor inner join tbl_contactos_proveedor as CP on OC.fk_id_contacto = CP.id_contactoProv inner join cat_divisas as D on OC.fk_id_divisa = D.id_moneda inner join cat_statusoc as SOC on OC.fk_id_statusOC = SOC.id_statusOC where OC.$item = :$item");
        $stmt -> bindParam(":".$item,$valor, PDO::PARAM_STR);
        $stmt ->execute();
        return $stmt ->fetchall();
      }else {
        $stmt = conexion::conectar()->prepare("SELECT * FROM $tabla AS OC inner join cat_proveedores as P on OC.id_proveedor = P.id_proveedor inner join tbl_contactos_proveedor as CP on OC.fk_id_contacto = CP.id_contactoProv inner join cat_divisas as D on OC.fk_id_divisa = D.id_moneda inner join cat_statusoc as SOC on OC.fk_id_statusOC = SOC.id_statusOC");
        $stmt ->execute();
        return $stmt ->fetchall();
      }
      $stmt->close();
      $stmt=null;
    }
    static public function mdlGetMaterialesOC($tabla,$item,$valor){
      if ($item !== null) {
        $stmt = conexion::conectar()->prepare("SELECT * FROM $tabla AS OCD inner join tbl_ordenescompra as OC on OCD.fk_id_OC = OC.id_ordenCompra inner join tbl_requi_material as RM on OCD.fk_id_RequiMat = RM.id_requi_material where OCD.$item = :$item");
        $stmt -> bindParam(":".$item,$valor, PDO::PARAM_STR);
        $stmt ->execute();
        return $stmt ->fetchall();
      }
      $stmt->close();
      $stmt=null;
    }    static public function mdlUpdateOC($tabla,$datos){
    //  var_dump($datos);exit;
      try {
       $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET id_proveedor = :id_proveedor, fk_id_contacto = :fk_id_contacto, fk_id_divisa = :fk_id_divisa, oc_observaciones = :oc_observaciones, fk_id_statusOC = :fk_id_statusOC, oc_fecha_creado = :oc_fecha_creado WHERE id_ordenCompra = :id_ordenCompra");

       $stmt->bindParam(":id_ordenCompra", $datos["id_ordenCompra"], PDO::PARAM_STR);
       $stmt->bindParam(":id_proveedor", $datos["id_proveedor"], PDO::PARAM_STR);
       $stmt->bindParam(":fk_id_contacto", $datos["fk_id_contacto"], PDO::PARAM_STR);
       $stmt->bindParam(":fk_id_divisa", $datos["fk_id_divisa"], PDO::PARAM_STR);
       $stmt->bindParam(":oc_observaciones", $datos["oc_observaciones"], PDO::PARAM_STR);
       $stmt->bindParam(":fk_id_statusOC", $datos["fk_id_statusOC"], PDO::PARAM_STR);
       $stmt->bindParam(":oc_fecha_creado", $datos["oc_fecha_creado"], PDO::PARAM_STR);

       if($stmt->execute()){
        return "ok";
       }else{
         return  $stmt -> errorInfo();
       }
       $stmt->close();
       $stmt = null;
      } catch (PDOException $e) {
        return $e->getMessage();

      }
    }
    static public function mdlDeleteMat($tabla,$datos){
      try {
       $stmt = Conexion::conectar()->prepare("DELETE FROM $tabla  WHERE id_ocDetalle = :id_ocDetalle");
       $stmt->bindParam(":id_ocDetalle", $datos["id_ocDetalle"], PDO::PARAM_STR);
       if($stmt->execute()){
        return "ok";
       }else{
         return  $stmt -> errorInfo();
       }
       $stmt->close();
       $stmt = null;
      } catch (PDOException $e) {
        return $e->getMessage();
      }
    }
    static public function mdlUpdateStatusMat($tabla,$datos){
      try {
       $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET requiM_status = :requiM_status WHERE id_requi_material = :id_requi_material");
       $stmt->bindParam(":id_requi_material", $datos["id_requi_material"], PDO::PARAM_STR);
       $stmt->bindParam(":requiM_status", $datos["requiM_status"], PDO::PARAM_STR);
       if($stmt->execute()){
        return "ok";
       }else{
         return  $stmt -> errorInfo();
       }
       $stmt->close();
       $stmt = null;
      } catch (PDOException $e) {
        return $e->getMessage();
      }
    }
    static public function mdlUpdateMontosOC($tabla,$datos){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET oc_iva = :oc_iva, oc_total = :oc_total WHERE id_ordenCompra = :id_ordenCompra");
        $stmt->bindParam(":id_ordenCompra", $datos["id_ordenCompra"], PDO::PARAM_STR);
        $stmt->bindParam(":oc_iva", $datos["oc_iva"], PDO::PARAM_STR);
        $stmt->bindParam(":oc_total", $datos["oc_total"], PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }

    static public function mdlUpdateStatusOC($tabla,$datos){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET fk_id_statusOC = :fk_id_statusOC WHERE id_ordenCompra = :id_ordenCompra");
        $stmt->bindParam(":id_ordenCompra", $datos["id_ordenCompra"], PDO::PARAM_STR);
        $stmt->bindParam(":fk_id_statusOC", $datos["fk_id_statusOC"], PDO::PARAM_STR);

        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }

  }

 ?>
